/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeDialog;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeKill;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeLocation;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeManual;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.quests.QuestObjective;

public class SubGuiQuestObjectiveSelect
extends SubGuiInterface {
    public Quest quest;

    public SubGuiQuestObjectiveSelect(GuiScreen gui) {
        this.setBackground("companion_empty.png");
        this.xSize = 172;
        this.ySize = 167;
        this.closeOnEsc = true;
        this.parent = gui;
        this.quest = NoppesUtilServer.getEditingQuest((EntityPlayer)this.player);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 66: {
                this.close();
                return;
            }
            case 71: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.ITEM);
                Client.sendData(EnumPacketServer.QuestReset, this.quest.save(new NBTTagCompound()), this.quest.questInterface.getPos(task));
                return;
            }
            case 72: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.CRAFT);
                Client.sendData(EnumPacketServer.QuestReset, this.quest.save(new NBTTagCompound()), this.quest.questInterface.getPos(task));
                return;
            }
            case 73: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.KILL);
                this.setSubGui(new GuiNpcQuestTypeKill(this.npc, task, this.parent));
                return;
            }
            case 74: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.AREAKILL);
                this.setSubGui(new GuiNpcQuestTypeKill(this.npc, task, this.parent));
                return;
            }
            case 75: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.DIALOG);
                this.setSubGui(new GuiNpcQuestTypeDialog(this.npc, task, this.parent));
                return;
            }
            case 76: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.LOCATION);
                this.setSubGui(new GuiNpcQuestTypeLocation(this.npc, task, this.parent));
                return;
            }
            case 77: {
                QuestObjective task = (QuestObjective)this.quest.addTask();
                if (task == null) {
                    return;
                }
                task.setType(EnumQuestTask.MANUAL);
                this.setSubGui(new GuiNpcQuestTypeManual(this.npc, task, this.parent));
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(80, "task.chose", this.guiLeft + 4, this.guiTop + 5));
        GuiNpcButton button = new GuiNpcButton(71, this.guiLeft + 4, this.guiTop + 18, 80, 20, "enum.quest.item");
        button.setHoverText("drop.hover.task.0", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(72, this.guiLeft + 87, this.guiTop + 18, 80, 20, "enum.quest.craft");
        button.setHoverText("drop.hover.task.1", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(73, this.guiLeft + 4, this.guiTop + 40, 80, 20, "enum.quest.kill");
        button.setHoverText("drop.hover.task.2", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(74, this.guiLeft + 87, this.guiTop + 40, 80, 20, "enum.quest.area_kill");
        button.setHoverText("drop.hover.task.3", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(75, this.guiLeft + 4, this.guiTop + 62, 80, 20, "enum.quest.dialog");
        button.setHoverText("drop.hover.task.4", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(76, this.guiLeft + 87, this.guiTop + 62, 80, 20, "enum.quest.location");
        button.setHoverText("drop.hover.task.5", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(77, this.guiLeft + 4, this.guiTop + 84, 80, 20, "enum.quest.manual");
        button.setHoverText("drop.hover.task.6", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, this.guiLeft + 4, this.guiTop + 142, 80, 20, "gui.back");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }
}

